function put_org_wks(h,mat)

% Syntax: put_org_wks(h,mat) 
% where 'h' is an ActiveX handle and 'mat' is a matrix to be dumped to an
% Origin worksheet.  This will also plot the data in specific cases:
% 
% Number of columns=2
% This assumes we have X,Y data and it automatically plots the data
%
% Number of columns=3
% This assumes we have X,Y,E data and it automatically plots with errorbars
%
% Number of columns=8
% This assumes the results of fitting a temperature series of scans to a single Gaussian.  
% The assumed columns are:
% Run Temp. Area dArea Pos dPos FWHM dFWHM
%
% Number of columns=14
% This assumes fitting a temperature series to 2 Gaussians.  The assumed
% columns are:
% Run Temp. Area1 dArea1 Pos1 dPos1 FWHM1 dFWHM1 Area2 dArea2 Pos2 dPos2 FWHM2 dFWHM2
%
% It is easy to modify this file to handle other cases with different
% numbers of columns.
jk=size(mat)
invoke(h,'Execute','doc -cw Data')
    numwks=get(h,'LTVAR','count');
    wksname=strcat('Data',num2str(numwks+1));
    tststr=sprintf('Win -n data %s',wksname);
    invoke(h,'Execute',tststr);
    tststr=sprintf('Worksheet -a %d',jk(2));
    invoke(h,'Execute',tststr);
    invoke(h,'Putworksheet',wksname,mat,0,0)
    sizemat=size(mat);
    if sizemat(2) == 3
        invoke(h,'Execute','Worksheet -t 1 4'); 
        invoke(h,'Execute','Worksheet -t 2 1');
        invoke(h,'Execute','Worksheet -t 3 3');
        invoke(h,'Execute','worksheet -s 0 0 1 0 ');
        invoke(h,'Execute','worksheet -p 202 errbar ');
    elseif sizemat(2) == 2
        invoke(h,'Execute','Worksheet -t 1 4'); 
        invoke(h,'Execute','Worksheet -t 2 1');
        invoke(h,'Execute','worksheet -s 0 0 1 0 ');
        invoke(h,'Execute','worksheet -p 202 linesymb ');
    elseif sizemat(2) == 8
        invoke(h,'Execute','Worksheet -t 1 2');
        invoke(h,'Execute','Worksheet -t 2 4'); 
        invoke(h,'Execute','Worksheet -t 3 1');
        invoke(h,'Execute','Worksheet -t 4 3');
        invoke(h,'Execute','Worksheet -t 5 1');
        invoke(h,'Execute','Worksheet -t 6 3');
        invoke(h,'Execute','Worksheet -t 7 1');
        invoke(h,'Execute','Worksheet -t 8 3');
        invoke(h,'Execute','Worksheet -n 1 Run');
        invoke(h,'Execute','Worksheet -n 2 Temp'); 
        invoke(h,'Execute','Worksheet -n 3 Area');
        invoke(h,'Execute','Worksheet -n 4 dArea');
        invoke(h,'Execute','Worksheet -n 5 Pos');
        invoke(h,'Execute','Worksheet -n 6 dPos');
        invoke(h,'Execute','Worksheet -n 7 fwhm');
        invoke(h,'Execute','Worksheet -n 8 dfwhm');
        invoke(h,'Execute','worksheet -s 0 0 1 0 ');
        invoke(h,'Execute','worksheet -p 202 linesymb ');
     elseif sizemat(2) == 14
        invoke(h,'Execute','Worksheet -t 1 2');
        invoke(h,'Execute','Worksheet -t 2 4'); 
        invoke(h,'Execute','Worksheet -t 3 1');
        invoke(h,'Execute','Worksheet -t 4 3');
        invoke(h,'Execute','Worksheet -t 5 1');
        invoke(h,'Execute','Worksheet -t 6 3');
        invoke(h,'Execute','Worksheet -t 7 1');
        invoke(h,'Execute','Worksheet -t 8 3');
        invoke(h,'Execute','Worksheet -t 9 1');
        invoke(h,'Execute','Worksheet -t 10 3');
        invoke(h,'Execute','Worksheet -t 11 1');
        invoke(h,'Execute','Worksheet -t 12 3');
        invoke(h,'Execute','Worksheet -t 13 1');
        invoke(h,'Execute','Worksheet -t 14 3');
        invoke(h,'Execute','Worksheet -n 1 Run');
        invoke(h,'Execute','Worksheet -n 2 Temp'); 
        invoke(h,'Execute','Worksheet -n 3 Area1');
        invoke(h,'Execute','Worksheet -n 4 dArea1');
        invoke(h,'Execute','Worksheet -n 5 Pos1');
        invoke(h,'Execute','Worksheet -n 6 dPos1');
        invoke(h,'Execute','Worksheet -n 7 fwhm1');
        invoke(h,'Execute','Worksheet -n 8 dfwhm1');
        invoke(h,'Execute','Worksheet -n 9 Area2');
        invoke(h,'Execute','Worksheet -n 10 dArea2');
        invoke(h,'Execute','Worksheet -n 11 Pos2');
        invoke(h,'Execute','Worksheet -n 12 dPos2');
        invoke(h,'Execute','Worksheet -n 13 fwhm2');
        invoke(h,'Execute','Worksheet -n 14 dfwhm2')
        invoke(h,'Execute','worksheet -s 0 0 1 0 ');
        invoke(h,'Execute','worksheet -p 202 linesymb ');
    end
    